clear();
clc();
close all;                              											%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
aLGS(1,:)=[ 2,  1, -0.5,  8, "X1","=",  4];
aLGS(2,:)=[ 6,  2,    8, 14, "X2","=", 12];
aLGS(3,:)=[ 1, -6,   10,  9, "X3","=",  1];
aLGS(4,:)=[ 2, 11,    3, -4, "X3","=",  4];

aX_(1)=0;
aX_(2)=0;
aX_(3)=0;
aX_(4)=0;
iGENAUIGKEIT=(10^-3)*100;                                                           %Angabe in %
sKommastellenDouble = '%.8f';          												%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_GLEICHUNGEN = size(aLGS,1);                                                 %Gibt die Anzahl an Zeilen zurück (Parameter 1)
iANZAHL_WERTE = size(aLGS,2)-3;                                                     %Gibt die Anzahl der Spalten zurück (Parameter 2) abzüglich 3 ("X";"=";Ergebnis)
if(iANZAHL_GLEICHUNGEN<iANZAHL_WERTE)
   fprintf("Scotty, wir haben ein Problem!\n"); 
   fprintf("Es gibt weniger Gleichungen als Unbekannte!\n"); 
   return;                                                                          %Hoffe das beendet das Skript vorzeitig
end
for(i=1:1:iANZAHL_GLEICHUNGEN)
    Zwischenspeicher=0;                                                             %Initialisierung
	for(k=1:1:iANZAHL_WERTE)
        if(k==i)
        else
            Zwischenspeicher=Zwischenspeicher+abs(str2double(aLGS(i,k)));
        end
    end
    if(abs(str2double(aLGS(i,i)))<Zwischenspeicher)
        fprintf("Scotty, wir haben ein Problem!\n"); 
        fprintf("Das Gleichungssystem ist mit Element a(%u,%u) nicht diagonaldominant!\n",i,i);     
    else
    end
end
fprintf("Lineares Gleichungssystem b=A*x \n");
disp(aLGS);

%INITIALISIERUNG-------------------------------------------------------------------
aWERTETABELLE=strings(1,(2*iANZAHL_GLEICHUNGEN)+1);
aWERTETABELLE(1)="Iteration";
for(i=2:2:(2*iANZAHL_GLEICHUNGEN))
    aWERTETABELLE(i)=[strcat("X",num2str(i/2))];
    aWERTETABELLE(i+1)=[strcat("|Ea|_",num2str(i/2)," [%]")];
end
aA(:,1:iANZAHL_WERTE)=str2double(aLGS(:,1:iANZAHL_WERTE));
aX=aX_;

%ITERATION-------------------------------------------------------------------------
iMERKER=0;
i=1;
while(1)
    %BERECHNUNG_DES_LÖSUNGSVEKTORS-------------------------------------------------
    for(j=1:1:iANZAHL_GLEICHUNGEN)
        Zwischenspeicher = 0;
        for(k=1:1:iANZAHL_WERTE)
            if(k==j)                                                                %Für den Fall k=j nichts machen, weil durch den am Ende geteilt wird
            else
                Zwischenspeicher=Zwischenspeicher+(aA(j,k)*aX(k));
            end
        end
        aX_(j)=aX(j);
        aX(j)=(str2double(aLGS(j,size(aLGS,2)))-Zwischenspeicher)/aA(j,j);
    end
    %BESCHREIBEN_WERTETABELLE------------------------------------------------------
    iMERKER=0;                                                                      %Merker wird vor jeder Prüfung einer Zeile auf 0 gesetzt
    aWERTETABELLE(i+1,1)=i;
    for(j=2:2:(2*iANZAHL_GLEICHUNGEN))
        aWERTETABELLE(i+1,j)=num2str(aX(j/2),sKommastellenDouble);
        aWERTETABELLE(i+1,j+1)=num2str(abs((aX(j/2)-aX_(j/2))/aX(j/2))*100,sKommastellenDouble);
        if(str2double(aWERTETABELLE(i+1,j+1)) <= iGENAUIGKEIT)
            iMERKER=iMERKER+1;
        else
        end
    end
    %ABBRUCHPRÜFUNG----------------------------------------------------------------
    if(iMERKER==iANZAHL_GLEICHUNGEN)
        break;                                                                      %Wenn die Genauigkeit aller x-Variablen unterschritten, breche ab
    else
        i=i+1;
    end
end
disp(aWERTETABELLE);

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aLGS aX aWERTETABELLE                                             %Workspace aufräumen